# This file is part of EventGhost.
# Copyright (C) 2005 Lars-Peter Voss <bitmonster@eventghost.org>
# Copyright (C) 2010 Gerald Himmelein <ghi@ct.de>
#
# EventGhost is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# EventGhost is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with EventGhost; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

import eg

eg.RegisterPlugin(
    name="PowerDVD 10",
    description="Adds actions to control CyberLink PowerDVD 10.",
    kind="program",
    author="Gerald Himmelein, based on BitMonster's plug-in",
    version="1.0" + "$LastChangedRevision: 1000 $".split()[1],
    createMacrosOnAdd=True,
)

ACTIONS = [
    ("Play", "Play", "Play movie or media", "{Return}"),
    ("Pause", "Pause", "Pause playback", "{Space}"),
    ("Stop", "Stop", "Stop playback", "{s}"),
    ("Open", "Select Drive", "Select drive", "{Ctrl+o}"),
    ("Eject", "Eject", "Eject media", "{Ctrl+e}"),
    ("Close", "Close", "Exit PowerDVD", "{Ctrl+x}"),
    ("ScanForward", "Scan Forward", "Fast forward", "{f}"),
    ("ScanBackward", "Scan Backward", "Fast reverse", "{b}"),
    ("ChapterNext", "Next Chapter", "Skip to next chapter", "{n}"),
    ("ChapterPrevious", "Previous Chapter", "Skip to previous chapter", "{p}"),
    ("SkipForward", "Skip Forward", "Skip forward x seconds", "{PageUp}"),
    ("SkipBack", "Skip Backward", "Skip back x seconds", "{PageDown}"),
    ("MenuList", "Menu List", "List available Menus", "{l}"),
    ("DVDRootMenu", "DVD Root Menu", "Display DVD Root Menu", "{j}"),
    ("BDPopupMenu", "BD Popup Menu", "Display Blu-ray Popup Menu", "{Ctrl+p}"),
    ("InfoOSD", "Info OSD", "Display information On-Screen-Display", "{d}"),
    ("Zoom", "Zoom", "Toggle fullscreen mode", "{z}"),
    ("AddBookmark", "Add Bookmark", "Add bookmark", "{m}"),
    ("Screenshot", "Capture Frame", "Capture DVD frame", "{c}"),
    ("ContextMenu", "Context Menu", "Open app context menu", "{Apps}"), 
    ("Cancel", "Cancel", "Cancels operation", "{Esc}"), 
    ("Angle", "Angle", "Activate next angle", "{a}"),
    ("Subtitle", "Subtitle", "Toggle between subtitles", "{u}"),
    ("SecondarySubtitle", "Secondary Subtitle", "Toggle between secondary subtitles", "Ctrl+u}"),
    ("SayItAgain", "Say It Again", "Repeat last line of dialog", "{w}"),
    ("AudioNext", "Next Audio", "Switch audio stream", "{h}"),
    ("NavigateUp", "Navigate Up", "Navigate through disk menu", "{Up}"),
    ("NavigateDown", "Navigate Down", "Navigate through disk menu", "{Down}"),
    ("NavigateRight", "Navigate Right", "Navigate through disk menu", "{Right}"),
    ("NavigateLeft", "Navigate Left", "Navigate through disk menu", "{Left}"),
    ("NavigateEnter", "Navigate OK", "Navigation OK button", "{Return}"),
    ("VolumeUp", "Volume Up", "Increase volume", "{+}"),
    ("VolumeDown", "Volume Down", "Decrease volume", "{-}"),
    ("VolumeMute", "Mute Volume", "Mute audio", "{q}"),
    ("Red", "Red Button", "Red remote button", "{F9}"),
    ("Green", "Green Button", "Green remote button", "{F10}"),
    ("Yellow", "Yellow Button", "Yellow remote button", "{F11}"),
    ("Blue", "Blue Button", "Blue remote button", "{F12}"),
    ("SubtitleOff", "Subtitle off", "Turn off subtitles, ugly hack", "{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Return}"),
    ("ClosedCaptionsOn", "Closed Captions on", "Activate Closed Captions, ugly hack", "{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Return}"),
    ("ClosedCaptionsOff", "Closed Captions off", "Turn off Closed Captions, ugly hack","{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Down}{Return}"),
]


gWindowMatcher = eg.WindowMatcher('PowerDVD{*}.exe', 'CyberLink PowerDVD{*}')


class ActionPrototype(eg.ActionBase):

    def __call__(self):
        hwnds = gWindowMatcher()
        if hwnds:
            eg.SendKeys(hwnds[0], self.value)
        else:
            raise self.Exceptions.ProgramNotRunning



class PowerDvd(eg.PluginBase):

    def __init__(self):
        self.AddActionsFromList(ACTIONS, ActionPrototype)

